from Tkinter import *
import Tkinter, tkFileDialog, tkMessageBox, os, sys, re
from idlelib.WidgetRedirector import WidgetRedirector

from FreezeHelpers import *

from TaskDescription import *
from FileWalker import FileWalker
from BatchExecutionDialog import *

from AbletonFix import AbletonFix
from StudioOneFix import StudioOneFix
from CubaseFix import CubaseFix
from SonarFix import SonarFix
from RenameH2pFiles import RenameH2pFiles

TEXT_FIELD_WIDTH = 60


# avoid unicode annoyance
reload(sys)  
sys.setdefaultencoding('utf8')

# redirect logging
if sys.platform.startswith('win'):
	logFile = open("Converter.log", "w")
	sys.stdout = logFile
	sys.stderr = logFile


class NoInteractionScrolTextBox(Frame):
	def __init__(self, root, *args, **kwargs):
		Frame.__init__(self, root, *args, **kwargs)
		self.root = root
		
		self.textFrame=Frame(root)
		self.pack_propagate(False)
		self.config(height=1)
		self.textFrame.pack(fill=BOTH)
		
		
		self.vsb = Scrollbar(self.textFrame, orient="vertical")
		self.hsb = Scrollbar(self.textFrame, orient="horizontal")
		
		self.text = Text(self.textFrame, wrap=NONE, 
				    yscrollcommand=self.vsb.set, xscrollcommand=self.hsb.set, height=8)
		
		# make text field read only
		self.redirector = WidgetRedirector(self.text)
		self.text.insert = self.redirector.register("insert", lambda *args, **kw: "break")
		self.text.delete = self.redirector.register("delete", lambda *args, **kw: "break")
				
		self.vsb.config(command=self.text.yview)
		self.vsb.pack(side="right", fill="y")
		self.hsb.config(command=self.text.xview)
		self.hsb.pack(side="bottom", fill="x")
		
		self.text.config(state=DISABLED)
	
		#for i in range(1000):
		#	self.insert("end", str(i))
			
		
		self.text.pack(side="left", fill="both", expand=True)


	def delete( self, inFrom, inTo):
		self.text.config(state=NORMAL)
		self.text.delete('1.0', END)
		self.text.config(state=DISABLED)


	def insert(self, inAt, labelText):
		self.text.config(state=NORMAL)
		self.text.insert("end", labelText)
		self.text.insert("end", "\n")
		self.text.config(state=DISABLED)



noOptionsMessage = "No options available"
	
class Converter:
	def __init__(self):
		self.filePathsInSelectedFolder = []
		self.listOfExtensions = []
		self.commandList = []
		self.inputFolderPath = None

	def generateCommandList(self):
		if areWeFrozen():
			if areWeInMacApp():
				binFolder = os.path.abspath('bin_mac')
			else:
				#binFolder = os.path.abspath(os.path.join( getThisAppsFolder() , '..', 'bin') )
				binFolder = os.path.abspath(os.path.join( getThisAppsFolder() , 'bin') )
		else:
			if sys.platform.startswith('win'):
				binFolder = os.path.abspath(os.path.join( getThisAppsFolder(), 'bin\\bin_win') )
			else:
				binFolder = os.path.abspath(os.path.join( getThisAppsFolder(), 'bin/bin_mac') )
				
		commandDescriptionJsons = []
		if os.path.isdir( binFolder ):	
			commandDescriptionJsons = FileWalker.findAbsolutePathsOfFilesIn( binFolder, ['json'] )
		
		self.commandList = []
		print "commands in path: " + binFolder
		for i in commandDescriptionJsons:
			print i
			fileNameOfI = os.path.basename( i )
			if fileNameOfI.startswith("CommandDefinition") and fileNameOfI.endswith(".json"):
				try:
					self.commandList.append( CommandLineTaskDescription.createFromJsonFile(i) )
				except:
					tkMessageBox.showwarning( "Parsing Error", "Program was not able to parse " + str(i) )
		
		# add build in conversions to list 		
		self.commandList.append( AbletonFix() )
		self.commandList.append( StudioOneFix() )
		self.commandList.append( CubaseFix() )
		self.commandList.append( SonarFix() )
		# self.commandList.append( RenameH2pFiles() )
		
	
class ConverterGUI(Tkinter.Frame):
	def __init__(self, parent):
		Tkinter.Frame.__init__(self, parent, relief=GROOVE)
		
		self.parent = parent
		
		if sys.platform.startswith('win'):
			iconPath = os.path.join( getThisAppsFolder(), 'u-he.ico')
			if os.path.isfile( iconPath ):
				root.iconbitmap( iconPath )
		
		self.converter = Converter()
		
		# init convertions by parsing json files
		self.converter.generateCommandList()
		
		# stringVars / binds
		self.selectedActionName = StringVar(parent)
		self.selectedActionName.set(noOptionsMessage)
		

		self.selectedPathLabelText = StringVar(parent)
		self.selectedPathLabelText.set("")

		self.foundFileTypesLabelText = StringVar(parent)
		self.foundFileTypesLabelText.set("")
		
		self.filesToBeConvertedLabelText = StringVar(parent)
		self.filesToBeConvertedLabelText.set("0 files to be converted")
		
		# states
		self.isAffectedFilesWidgetVisible = False
		
		self.setupGUI()
		
	# callbacks
	def onUpdateActionOptions(self):
		if self.converter.inputFolderPath:
			self.selectedActionName.set("Select conversion...")
			self.actionSelector.config(state=NORMAL)
		else:
			self.selectedActionName.set("No input folder selected")
			self.actionSelector.config(state=DISABLED)
			return
			
		self.actionSelector['menu'].delete(0, 'end')
		addedOptionToList = False
		commandsAlreadyAdded = []
		print str(self.converter.listOfExtensions)
		if self.converter.commandList:
			for cmd in self.converter.commandList:
				for e in self.converter.listOfExtensions:
					e = e.replace(".", "")
					if e in cmd.supportedFileTypes and not cmd.displayName in commandsAlreadyAdded:
						commandsAlreadyAdded.append(cmd.displayName)
						
						supportedFilesStr = " ("
						for sf in cmd.supportedFileTypes:
							supportedFilesStr += sf
							if not sf == cmd.supportedFileTypes[-1]:
								supportedFilesStr += ", "
						supportedFilesStr += ")"
						
						self.actionSelector['menu'].add_command(label=(cmd.displayName + supportedFilesStr), command=Tkinter._setit(self.selectedActionName, cmd.displayName))
						addedOptionToList = True
		
		if not addedOptionToList:
			self.selectedActionName.set("No matching conversion available for input files")
			self.actionSelector.config(state=DISABLED)

	def onConvert(self):
		cmd = self.getSelectedActionsDefinition()
		if cmd:
			listOfFilesToConvert = []
			for i in self.converter.filePathsInSelectedFolder:
				filename, fileExtension = os.path.splitext( str(i) )
				if fileExtension.replace(".", "") in cmd.supportedFileTypes:
					listOfFilesToConvert.append(i)
			if listOfFilesToConvert:
				if isinstance( cmd, CommandLineTaskDescription ):
					theCommandLine = self.getCommandStringWithArgumentWithoutFileToConvert( cmd.defaultArgumentsString )
					#start modal dialog and execute the command
					#tkMessageBox.showinfo("cmd", theCommandLine)
					#return
					task = CommandLineBatchExecutionTask( theCommandLine )
					cmdDialog = BatchExecutionDialog( root, listOfFilesToConvert, task )
					
				elif isinstance( cmd, CallbackTaskDescription ) and isinstance( cmd, CallbackBatchExecutionTask ) :
					cmdDialog = BatchExecutionDialog( root, listOfFilesToConvert, cmd )
				else:
					tkMessageBox.showinfo( "Error", "What kind of task is this?" )
					return
					
				cmdDialog.execute( )
				
				if cmdDialog.isCanceled( ):
					tkMessageBox.showinfo( "Conversion canceled", "Operation was canceled." )
				else:
					if not cmdDialog.getErrorText():
						tkMessageBox.showinfo( "Conversion finished", "All files converted!" )
					else:
						if tkMessageBox.askyesno("Conversion finished", "Not all files could be converted. Show Report?"):
							ErrorLogWindow( root, cmdDialog.getErrorText() )
				return
		
		tkMessageBox.showinfo("Invalid configuration", "To convert files, please select an input folder and a conversion")

	def onActionSelected(self, *args):
		self.affectedFilesListBox.delete(0, END)
		
		matchingFileCounter = 0
		for cmd in self.converter.commandList:
			if cmd.displayName == self.selectedActionName.get():
				for i in self.converter.filePathsInSelectedFolder:
					filename, fileExtension = os.path.splitext( i.encode('utf-8') )
					if fileExtension.replace(".", "") in cmd.supportedFileTypes:
						self.affectedFilesListBox.insert( END, str(i) )
						matchingFileCounter += 1
						
		self.filesToBeConvertedLabelText.set(str(matchingFileCounter) + " files to be converted")
	   
	def onSelectFolder(self):
		self.converter.inputFolderPath = tkFileDialog.askdirectory(parent=root,initialdir="/",title='Please select a directory')
		if len(self.converter.inputFolderPath ) > 0:
			print "scanning %s" % self.converter.inputFolderPath
			self.selectedPathLabelText.set(self.converter.inputFolderPath)
			
			self.foundFileTypesLabelText.set("scanning..")
			self.parent.update_idletasks() # make label change visible
			self.converter.filePathsInSelectedFolder = FileWalker.findAbsolutePathsOfFilesIn(self.converter.inputFolderPath)
			self.affectedFilesListBox.delete(0, END)
			foundFileTypesAsStr = "Found file types: "
			self.converter.listOfExtensions = []
			
			for i in self.converter.filePathsInSelectedFolder:
				filename, fileExtension = os.path.splitext( i.encode('utf-8') )
				self.converter.listOfExtensions.append( str(fileExtension) )
			
			# make unique extension list 
			set = {}
			map(set.__setitem__, self.converter.listOfExtensions, [])
			self.converter.listOfExtensions = set.keys()
			for e in self.converter.listOfExtensions:
				if not e == "":
					foundFileTypesAsStr += e
					if not e == self.converter.listOfExtensions[-1]:
						foundFileTypesAsStr += ", "
			
			if len(foundFileTypesAsStr) > TEXT_FIELD_WIDTH - 3:
			    foundFileTypesAsStr = foundFileTypesAsStr[:TEXT_FIELD_WIDTH - 3] + "..."
			self.onUpdateActionOptions()
			self.foundFileTypesLabelText.set(foundFileTypesAsStr)

	def onHideShowAffectedFilesFrame(self):
		if self.isAffectedFilesWidgetVisible:
			self.foundFilesScrollFrame.grid_forget()
			self.isAffectedFilesWidgetVisible = False
		else:
			self.foundFilesScrollFrame.grid( sticky=W+E+N+S, padx=5, pady=5)
			self.isAffectedFilesWidgetVisible = True
		self.foundFilesScrollFrame.update()
			
			
	def getSelectedActionsDefinition(self):
		for cmd in self.converter.commandList:
			if cmd.displayName == self.selectedActionName.get():
				return cmd
		return None
	
	def getCommandStringWithArgumentWithoutFileToConvert(self, argsString ):
		cmd = self.getSelectedActionsDefinition()
		if not cmd:
			return ""
		else:
			# make absolute and prevent issues with spaces in file path
			commandString = "\"" + str(os.path.join( cmd.getExecutableFolderPath(), '')) + cmd.cmdString.replace(" ", "\" ", 1)
			commandString = commandString.replace("%args", argsString)
			return commandString

	def getShortPathForDisplay(self, inPathString, maxLength):
		if len(inPathString) > maxLength:
			halfKeepLength = int(maxLength / 2)
			return re.sub(r'^(.{' + str(halfKeepLength) + '}).*(.{' + str(halfKeepLength) + '})$', '\g<1>...\g<2>', inPathString)
		else:
			return inPathString	
				
	def setupGUI(self):
			
		# frames
		self.grid(column=0, row=0, padx=10, pady=10, sticky=W+E+N+S)

		inputSelectionFrame = LabelFrame(self, text="1. Choose Input Folder", relief=GROOVE)
		inputSelectionFrame.grid(row = 0, column = 0, sticky=W+E+N+S)

		actionSelectionFrame = LabelFrame(self, text="2. Choose Conversion Option", relief=GROOVE)
		actionSelectionFrame.grid(row = 1, column = 0,sticky=W+E+N+S)
		actionSelectionFrame.columnconfigure(0, weight=1)

		executeFrame = Frame(self)
		executeFrame.grid(row = 2, column = 0, sticky=W+E+N+S)


		##### folder selection
		label = Tkinter.Label(inputSelectionFrame, textvariable=self.selectedPathLabelText, bg="white", width=TEXT_FIELD_WIDTH, anchor="w", relief=SOLID, bd=1)
		label.grid(column=0, row=0, padx=5, pady=5)

		selectFolderButton = Tkinter.Button(inputSelectionFrame, text="Browse...", command=self.onSelectFolder, anchor="e")
		selectFolderButton.grid(column=1, row=0, padx=5, pady=5)

		# found file types
		foundSupportedFileTypesLabel = Tkinter.Label(inputSelectionFrame, textvariable=self.foundFileTypesLabelText, width=TEXT_FIELD_WIDTH, anchor="w")
		foundSupportedFileTypesLabel.grid(column=0, row=1, padx=5, pady=5)

		##### action selection
		actionSectionRow = 0

		firstColumnFrame = Frame(actionSelectionFrame)
		firstColumnFrame.grid(column=0, row=actionSectionRow, padx=5, pady=5, columnspan=2, sticky=E+W)
		firstColumnFrame.columnconfigure(0, weight=1)

		#actionSelectorLabel = Tkinter.Label(firstColumnFrame, text="Conversion to execute:")
		#actionSelectorLabel.grid(column=0, row=0, padx=5, pady=5, sticky=W)

		actionNames = (noOptionsMessage)
		self.actionSelector = Tkinter.OptionMenu(firstColumnFrame, self.selectedActionName, actionNames)
		self.actionSelector.grid(column=0, row=0, padx=0, pady=5, sticky=W) #E
		self.actionSelector.config(state=DISABLED)

		# separator
		Frame(firstColumnFrame, height=2, bd=1, relief=SUNKEN).grid(column=0, row=1, padx=5, pady=5, columnspan=2, sticky=E+W)

		actionSectionRow += 1
		fileToBeConvertedLabel = Tkinter.Label(actionSelectionFrame, textvariable=self.filesToBeConvertedLabelText, width=TEXT_FIELD_WIDTH, anchor="w")
		fileToBeConvertedLabel.grid(column=0, row=actionSectionRow, padx=10, pady=5, sticky=W)
		
		self.foundFilesScrollFrame = LabelFrame(actionSelectionFrame, relief=RAISED)
		actionSectionRow += 1
		self.foundFilesScrollFrame.grid(row = actionSectionRow, column = 0, sticky=W+E+N+S, padx=5, pady=5)
		self.affectedFilesListBox = NoInteractionScrolTextBox(self.foundFilesScrollFrame)
		self.affectedFilesListBox.pack(fill=BOTH, padx=5, pady=5)

		##### execute
		executeButton = Tkinter.Button(executeFrame, text="Convert", command=self.onConvert)
		executeButton.grid(column=1, row=0, padx=5, pady=10, sticky=E)
		executeFrame.columnconfigure(0, weight=1)

		# register bindings
		self.selectedActionName.trace("w", self.onActionSelected)
		
# main starts here
root = Tkinter.Tk()
root.title("u-he File Converter")
#root.geometry('{}x{}'.format(2000, 1000))
root.resizable(width=FALSE, height=FALSE)

ConverterGUI(root)

# center window
root.update()
width = root.winfo_width()
height = root.winfo_height()
screenWidth = root.winfo_screenwidth()
screenHeight = root.winfo_screenheight()

x = (screenWidth/2) - (width/2)
y = (screenHeight/2) - (height/2)
root.geometry( "+%d+%d" %  (x, y) )


#ErrorLogWindow(root, "big text goes here")



root.mainloop()
   